//Copyright 2012-2013 Adobe Systems Incorporated.  All rights reserved.

var helpDoc = MM.HELP_jQueryDialog;			

var DIALOG_ID;
var TITLE_INPUT;
var POSITION_SELECT;
var WIDTH_INPUT;
var HEIGHT_INPUT;
var MAXWIDTH_INPUT;
var MAXHEIGHT_INPUT;
var MINWIDTH_INPUT;
var MINHEIGHT_INPUT;
var DRAGGABLE_CHECK;
var CLOSE_CHECK;
var AUTO_CHECK;
var MODAL_CHECK;
var RESIZABLE_CHECK;
var HIDE_SELECT;
var SHOW_SELECT;
var HIDE_INPUT;
var SHOW_INPUT;
var ELEMENT_SELECT;
var EVENT_SELECT;


// ********************* API FUNCTIONS ***************************

//--------------------------------------------------------------------
// FUNCTION:
//   canInspectSelection
//
// DESCRIPTION:
//   This is a Property Inspector API function that gets called
//   whenever the selection in the document changes to decide whether
//   or not this property inspector should be displayed.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   true if the currently selected node is a Dialog element,
//   false if it is not.
//--------------------------------------------------------------------

function canInspectSelection() 
{
	var bCanInspectSelection = false;
	var dom = dw.getDocumentDOM();
	var selectedNode = dom.getSelectedNode();
	
	if ( !selectedNode || !selectedNode.getTranslatedAttribute )
		return false;
	
	var attr = selectedNode.getTranslatedAttribute('dialog');
  
	if ( attr && attr.length > 0 )
	{

		bCanInspectSelection = true;
	
		// If the widget manager is out of sync, run the translator
		var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
		
		if (!widgetMgr)
			return;
	
		if ( !widgetMgr.getWidget('dialog', selectedNode.id ) )
		{ 
			dom.runTranslator("jQuery Widget");

			if ( !widgetMgr.getWidget('dialog', selectedNode.id ) )
		{ 
			// Running the translator failed to create a design time object
			// for this widget. Either caInspectSelection() was called in the
			// middle of an edit operation, which prevents the translator from
			// running right now, or an error occurred during the translation.

			bCanInspectSelection = false;
		}
		}  
	}

	return bCanInspectSelection;
}

//--------------------------------------------------------------------
// FUNCTION:
//   initializeUI
//
// DESCRIPTION:
//   This is an internal utility function that searches through the
//   Property Inspector document to find all of the UI controls we
//   will programatically manipulate, and stores handles to them in
//   global variables which are used in some of the other functions
//   for this Property Inspector.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function initializeUI() 
{
	DIALOG_ID = document.getElementById("idInput");	
	TITLE_INPUT = document.getElementById("titleInput");	
	POSITION_SELECT = new ListControl("positionSelect");
	WIDTH_INPUT = document.getElementById("widthInput");	
	HEIGHT_INPUT = document.getElementById("heightInput");	
	MAXWIDTH_INPUT = document.getElementById("maxwidthInput");	
	MAXHEIGHT_INPUT = document.getElementById("maxheightInput");	
	MINWIDTH_INPUT = document.getElementById("minwidthInput");	
	MINHEIGHT_INPUT = document.getElementById("minheightInput");	
	DRAGGABLE_CHECK = document.getElementById("draggableCheck");	
	CLOSE_CHECK = document.getElementById("closeCheck");	
	AUTO_CHECK = document.getElementById("autoCheck");	
	MODAL_CHECK = document.getElementById("modalCheck");	
	RESIZABLE_CHECK = document.getElementById("resizableCheck");	
	HIDE_SELECT = new ListControl("hideSelect");
	SHOW_SELECT = new ListControl("showSelect");
	HIDE_INPUT = document.getElementById("hideInput");	
	SHOW_INPUT = document.getElementById("showInput");	
	ELEMENT_SELECT = new ListControl("elementSelect");
	EVENT_SELECT = new ListControl("eventSelect");
}

//--------------------------------------------------------------------
// FUNCTION:
//   inspectSelection
//
// DESCRIPTION:
//   This is a Property Inspector API function that gets called
//   whenever the selection in the document has changed and it has
//   been decided that this Property Inspector should be displayed.
//   This function syncs up the Property Inspector UI with the
//   widget's design-time object so that it accurately reflects
//   what is in the widget HTML markup and its JS constructor.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function inspectSelection() 
{
	dw.logEvent(UT_JQUERY_DIALOG, UT_JQUERY_DIALOG_INSPECT);
	
	// Call initializeUI() here; it's how the global variables get
	// initialized. The onLoad event on the body tag is never triggered
	// in inspectors.
	initializeUI();

	var dom = dw.getDocumentDOM();
	var selectedNode = dom.getSelectedNode();
	
	if (!canInspectSelection())
		return;
		
	var divId = selectedNode.id;
	// Update the ID field in the PI.
	DIALOG_ID.value = divId;	
	
	var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
  
	if (!widgetMgr)
		return;
	
	var dialog = widgetMgr.getWidget('dialog', divId);
	
	if (!dialog)
	{
		return;
	}
	
	if (dialog && dialog.recalculateOpts)
		dialog.recalculateOpts();
	
	TITLE_INPUT.value = dialog.getTitleValue();
	
	var positionArray = dialog.getPositionArray();
	POSITION_SELECT.setAll(positionArray, positionArray);
	if (positionArray.length)
		POSITION_SELECT.setIndex(dialog.getPositionIndex());
	
	WIDTH_INPUT.value = dialog.getWidthValue();
	HEIGHT_INPUT.value = dialog.getHeightValue();
	MAXWIDTH_INPUT.value = dialog.getMaxWidthValue();
	MAXHEIGHT_INPUT.value = dialog.getMaxHeightValue();
	MINWIDTH_INPUT.value = dialog.getMinWidthValue();
	MINHEIGHT_INPUT.value = dialog.getMinHeightValue();
	
	DRAGGABLE_CHECK.checked = dialog.getDraggableValue();
	CLOSE_CHECK.checked = dialog.getCloseValue();
	AUTO_CHECK.checked = dialog.getAutoValue();
	MODAL_CHECK.checked = dialog.getModalValue();
	RESIZABLE_CHECK.checked = dialog.getResizableValue();
	
	var animationArray = dialog.getAnimationArray();
	HIDE_SELECT.setAll(animationArray, animationArray);
	var hideIndex = dialog.getHideEffectIndex();
	if (animationArray.length)
		HIDE_SELECT.setIndex(hideIndex);
	
	if(hideIndex)
		HIDE_INPUT.value = dialog.getHideDurationValue();
	else
		HIDE_INPUT.value = "";
	
	SHOW_SELECT.setAll(animationArray, animationArray);
	var showIndex = dialog.getShowEffectIndex();
	if (animationArray.length)
		SHOW_SELECT.setIndex(showIndex);
	
	if(showIndex)
		SHOW_INPUT.value = dialog.getShowDurationValue();
	else
		SHOW_INPUT.value = "";
		
	dialog.initElementArray();	
	var elementArray = dialog.getElementArray();
	ELEMENT_SELECT.setAll(elementArray, elementArray);
	var elementIndex = dialog.getElementIndex();
	if (elementArray.length)
		ELEMENT_SELECT.setIndex(elementIndex);	
	else
		ELEMENT_SELECT.setIndex(0);
		
	var eventArray = dialog.getEventArray();
	EVENT_SELECT.setAll(eventArray, eventArray);
	if (eventArray.length && elementIndex)
		EVENT_SELECT.setIndex(dialog.getEventIndex());	
	else
		EVENT_SELECT.setIndex(0);	
	
	enableControls(dialog);

}

//--------------------------------------------------------------------
// FUNCTION:
//   enableControls
//
// DESCRIPTION:
//   This internal utility function enables/disables the controls
//   in the Property Inspector based on the state of the widget
//   design-time object.
//
// ARGUMENTS:
//  dialog - object - The widget design-time object.
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function enableControls(dialog)
{
  if( HIDE_SELECT.getIndex() > 0 )
		HIDE_INPUT.disabled = false;
	else
		HIDE_INPUT.disabled = true;
		
	if( SHOW_SELECT.getIndex() > 0 )
		SHOW_INPUT.disabled = false;
	else
		SHOW_INPUT.disabled = true;	
		
	if( ELEMENT_SELECT.getIndex() > 0 )
		EVENT_SELECT.enable();
	else
		EVENT_SELECT.disable();
}


//--------------------------------------------------------------------
// FUNCTION:
//   updateTag
//
// DESCRIPTION:
//   This function handles all of the user actions triggered by the
//   user from the Propery Inspector controls.
//
// ARGUMENTS:
//  action - string - The name of the action to perform.
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------
function updateTag(action)
{
	var dom = dw.getDocumentDOM();
	var selectedNode = dom.getSelectedNode();
	if (!canInspectSelection())
		return;
  
	var divId = selectedNode.id;
  
	var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
	var dialog = widgetMgr.getWidget('dialog', divId );
	if ( !dialog )
		return;
    
	if (action) 
	{
		switch (action)
		{
			case "id":
			{
				// Validate the new id.
				var newId = DIALOG_ID.value;
				if ( newId == divId )
				  return; // Nothing to change.
				
				if ( newId.length == 0 )
				{
				  alert(dw.loadString("jquery/widget/alert/need unique id"));
				  return;
				}
				
				if ( dom.getElementById(newId) )
				{
				  alert(dw.loadString("jquery/widget/alert/id already exists"));
				  return;
				}
				
				if ( !dwscripts.isValidID(newId) )
				{
				  alert(dw.loadString("jquery/widget/alert/id is invalid"));
				  return;
				}
				
				// Update the constructor.
				dialog.updateWidgetId(newId);

				// Update the WidgetManager for the new ID.
				widgetMgr.setWidget('dialog', newId, dialog );
			}
			break;
			
			case 'setTitle':
			{
				dialog.setTitleValue(TITLE_INPUT.value);
			}
			break;
			case 'setPosition':
			{
				dialog.setPositionIndex(POSITION_SELECT.getIndex());
			}
			break;
			case 'setWidth':
			{
				dialog.setWidthValue(WIDTH_INPUT.value);
			}
			break;
			case 'setHeight':
			{
				dialog.setHeightValue(HEIGHT_INPUT.value);
			}
			break;
			case 'setMaxWidth':
			{
				dialog.setMaxWidthValue(MAXWIDTH_INPUT.value);
			}
			break;
			case 'setMaxHeight':
			{
				dialog.setMaxHeightValue(MAXHEIGHT_INPUT.value);
			}
			break;
			case 'setMinWidth':
			{
				dialog.setMinWidthValue(MINWIDTH_INPUT.value);
			}
			break;
			case 'setMinHeight':
			{
				dialog.setMinHeightValue(MINHEIGHT_INPUT.value);
			}
			break;
			case 'setDraggable':
			{
				dialog.setDraggableValue(DRAGGABLE_CHECK.checked);
			}
			break;
			case 'setClose':
			{
				dialog.setCloseValue(CLOSE_CHECK.checked);
			}
			break;
			case 'setAuto':
			{
				dialog.setAutoValue(AUTO_CHECK.checked);
			}
			break;
			case 'setModal':
			{
				dialog.setModalValue(MODAL_CHECK.checked);
			}
			break;
			case 'setResizable':
			{
				dialog.setResizableValue(RESIZABLE_CHECK.checked);
			}
			break;
			
			case 'setHideSelect':
			{
				dialog.setHideEffectIndex(HIDE_SELECT.getIndex());
			}
			break;
			case 'setShowSelect':
			{
				dialog.setShowEffectIndex(SHOW_SELECT.getIndex());
			}
			break;
			case 'setHideInput':
			{
				dialog.setHideDurationValue(HIDE_INPUT.value);
			}
			break;
			case 'setShowInput':
			{
				dialog.setShowDurationValue(SHOW_INPUT.value);
			}
			break;
			case 'setElement':
			{
				dialog.setElementIndex(ELEMENT_SELECT.getIndex());
			}
			break;
			case 'setEvent':
			{
				dialog.setEventIndex(EVENT_SELECT.getIndex());
			}
			break;
			
			
		}
		
   }

	// All these edits modify the Dialog. We need to recreate the JS Object to reflect those changes.
	dialog.refresh();

	// Make sure selection stays on the input.
	dom.setSelectedNode(selectedNode); 
	inspectSelection();
}
